/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.parse;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.eclipse.packager.rpm.Rpms;
import org.eclipse.packager.rpm.header.Type;

public class HeaderValue {
    private final int tag;
    private Object value;
    private final int originalType;
    private final Type type;
    private final int index;
    private final int count;

    public HeaderValue(int tag, int type, int index, int count) {
        this.tag = tag;
        this.originalType = type;
        this.type = Type.fromType(type);
        this.index = index;
        this.count = count;
    }

    public int getTag() {
        return this.tag;
    }

    public Object getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public int getIndex() {
        return this.index;
    }

    void fillFromStore(ByteBuffer storeData) throws IOException {
        switch (this.type) {
            case NULL: {
                break;
            }
            case CHAR: {
                this.value = this.getFromStore(storeData, true, buf -> Character.valueOf((char)storeData.get()), Character[]::new);
                break;
            }
            case BYTE: {
                this.value = this.getFromStore(storeData, true, ByteBuffer::get, Byte[]::new);
                break;
            }
            case SHORT: {
                this.value = this.getFromStore(storeData, true, ByteBuffer::getShort, Short[]::new);
                break;
            }
            case INT: {
                this.value = this.getFromStore(storeData, true, ByteBuffer::getInt, Integer[]::new);
                break;
            }
            case LONG: {
                this.value = this.getFromStore(storeData, true, ByteBuffer::getLong, Long[]::new);
                break;
            }
            case STRING: {
                storeData.position(this.index);
                this.value = HeaderValue.makeString(storeData);
                break;
            }
            case BLOB: {
                this.value = this.getBlob(storeData);
                break;
            }
            case STRING_ARRAY: 
            case I18N_STRING: {
                this.value = this.getFromStore(storeData, false, HeaderValue::makeString, String[]::new);
                break;
            }
            case UNKNOWN: {
                this.value = new Unknown(this.originalType, this.getBlob(storeData));
            }
        }
    }

    private byte[] getBlob(ByteBuffer storeData) {
        byte[] data = new byte[this.count];
        storeData.position(this.index);
        storeData.get(data);
        return data;
    }

    private <R> Object getFromStore(ByteBuffer data, boolean collapse, IOFunction<ByteBuffer, R> func, Function<Integer, R[]> creator) throws IOException {
        data.position(this.index);
        if (this.count == 1 && collapse) {
            return func.apply(data);
        }
        R[] result = creator.apply(this.count);
        for (int i = 0; i < this.count; ++i) {
            result[i] = func.apply(data);
        }
        return result;
    }

    private static String makeString(ByteBuffer buf) throws IOException {
        byte[] data = buf.array();
        int start = buf.position();
        for (int i = 0; i < buf.remaining(); ++i) {
            if (data[start + i] != 0) continue;
            buf.position(start + i + 1);
            return new String(data, start, i, StandardCharsets.UTF_8);
        }
        throw new IOException("Corrupt tag entry. Null byte missing!");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.tag);
        sb.append(" = ");
        Rpms.dumpValue(sb, this.value);
        sb.append(" - ").append((Object)this.type).append(" = ");
        if (this.value != null) {
            if (this.type == Type.UNKNOWN) {
                sb.append((Object)this.type);
            } else {
                sb.append(this.value.getClass().getName());
            }
        } else {
            sb.append("NULL");
        }
        sb.append(" # ");
        sb.append(this.count);
        sb.append(']');
        return sb.toString();
    }

    @FunctionalInterface
    public static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    static final class Unknown {
        private final int type;
        private final byte[] value;

        public Unknown(int type, byte[] value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public byte[] getValue() {
            return this.value;
        }

        public String toString() {
            return "UNKNOWN: type: " + this.type + ", data: " + BaseEncoding.base16().encode(this.value);
        }
    }
}

