/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.lang.reflect.Method;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.ClassMethodExistsQuery;
import org.anarres.jdiagnostics.JarQuery;
import org.anarres.jdiagnostics.Result;

public class DOMQuery
extends AbstractQuery {
    private static final String DOM_LEVEL2_CLASS = "org.w3c.dom.Document";
    private static final String DOM_LEVEL2_METHOD = "createElementNS";
    private static final String DOM_LEVEL2WD_CLASS = "org.w3c.dom.Node";
    private static final String DOM_LEVEL2WD_METHOD = "supported";
    private static final String DOM_LEVEL2FD_CLASS = "org.w3c.dom.Node";
    private static final String DOM_LEVEL2FD_METHOD = "isSupported";

    public String getName() {
        return "dom";
    }

    public void call(Result result, String prefix) {
        new JarQuery("dom.jar").call(result, prefix + "domJar/");
        Method m2 = new ClassMethodExistsQuery(DOM_LEVEL2_CLASS, DOM_LEVEL2_METHOD, String.class, String.class).findMethod(result, prefix + "v2/");
        if (m2 != null) {
            result.put(prefix + "version", ">=2.0");
            return;
        }
        Method m2wd = new ClassMethodExistsQuery("org.w3c.dom.Node", DOM_LEVEL2WD_METHOD, String.class, String.class).findMethod(result, prefix + "v2wd/");
        if (m2wd != null) {
            result.put(prefix + "version", "2.0 working draft");
            return;
        }
        Method m2fd = new ClassMethodExistsQuery("org.w3c.dom.Node", DOM_LEVEL2FD_METHOD, String.class, String.class).findMethod(result, prefix + "v2fd/");
        if (m2fd != null) {
            result.put(prefix + "version", "2.0 final draft");
            return;
        }
    }
}

