/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.packageurl.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.goodies.packageurl.RenderFlavor;

public class PackageUrlParamConverter
implements ParamConverter<PackageUrl> {
    @Nullable
    private final RenderFlavor flavor;

    public PackageUrlParamConverter(@Nullable RenderFlavor flavor) {
        this.flavor = flavor;
    }

    public PackageUrl fromString(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        return PackageUrl.parse(value);
    }

    public String toString(PackageUrl value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        return value.toString(this.flavor != null ? this.flavor : RenderFlavor.getDefault());
    }

    @Provider
    public static class ProviderImpl
    implements ParamConverterProvider {
        @Nullable
        private final RenderFlavor flavor;

        public ProviderImpl(RenderFlavor flavor) {
            this.flavor = flavor;
        }

        public ProviderImpl() {
            this(null);
        }

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            Objects.requireNonNull(rawType);
            if (rawType.equals(PackageUrl.class)) {
                return new PackageUrlParamConverter(this.flavor);
            }
            return null;
        }
    }
}

