/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.packageurl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

final class PercentEncoding {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();

    private PercentEncoding() {
    }

    public static String encode(String value) {
        String encoded = PercentEncoding.encodeName(value);
        encoded = PercentEncoding.simpleReplace(encoded, "%2F", "/");
        return encoded;
    }

    public static String encodeName(String value) {
        Objects.requireNonNull(value);
        try {
            String encoded = URLEncoder.encode(value, UTF_8);
            encoded = PercentEncoding.simpleReplace(encoded, "+", "%20");
            encoded = PercentEncoding.simpleReplace(encoded, "%3A", ":");
            encoded = PercentEncoding.simpleReplace(encoded, "%7E", "~");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String encodeVersion(String value) {
        return PercentEncoding.encode(value);
    }

    public static String encodeSegment(String value) {
        return PercentEncoding.encode(value);
    }

    public static String encodeQualifierValue(String value) {
        return PercentEncoding.encode(value);
    }

    public static String decode(String value) {
        Objects.requireNonNull(value);
        try {
            return URLDecoder.decode(value, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static String simpleReplace(String text, String target, String replacement) {
        int start = 0;
        int index = text.indexOf(target, start);
        if (index == -1) {
            return text;
        }
        StringBuilder stringBuilder = new StringBuilder(text.length());
        do {
            stringBuilder.append(text, start, index).append(replacement);
        } while ((index = text.indexOf(target, start = index + target.length())) != -1);
        stringBuilder.append(text, start, text.length());
        return stringBuilder.toString();
    }
}

