/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.packageurl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.sonatype.goodies.packageurl.MoreStrings;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.goodies.packageurl.PackageUrlParser;
import org.sonatype.goodies.packageurl.PackageUrlValidator;

public class PackageUrlBuilder {
    private boolean typeSpecificTransformations = true;
    private String type;
    private List<String> namespace;
    private String name;
    private String version;
    private Map<String, String> qualifiers;
    private List<String> subpath;

    public PackageUrlBuilder from(PackageUrl purl) {
        Objects.requireNonNull(purl);
        this.type = purl.getType();
        if (purl.getNamespace() != null) {
            this.namespace = new ArrayList<String>(purl.getNamespace());
        }
        this.name = purl.getName();
        this.version = purl.getVersion();
        if (purl.getQualifiers() != null) {
            this.qualifiers = new LinkedHashMap<String, String>(purl.getQualifiers());
        }
        if (purl.getSubpath() != null) {
            this.subpath = new ArrayList<String>(purl.getSubpath());
        }
        return this;
    }

    public PackageUrlBuilder typeSpecificTransformations(boolean enable) {
        this.typeSpecificTransformations = enable;
        return this;
    }

    public PackageUrlBuilder type(String type) {
        this.type = type;
        return this;
    }

    public PackageUrlBuilder namespace(List<String> namespace) {
        this.namespace = namespace;
        return this;
    }

    public PackageUrlBuilder namespace(String namespace) {
        return this.namespace(PackageUrlParser.parseNamespace(namespace));
    }

    public PackageUrlBuilder name(String name) {
        this.name = name;
        return this;
    }

    public PackageUrlBuilder version(String version) {
        this.version = version;
        return this;
    }

    private Map<String, String> getQualifiers() {
        if (this.qualifiers == null) {
            this.qualifiers = new LinkedHashMap<String, String>();
        }
        return this.qualifiers;
    }

    public PackageUrlBuilder qualifiers(Map<String, String> qualifiers) {
        if (qualifiers != null) {
            for (Map.Entry<String, String> entry : qualifiers.entrySet()) {
                this.qualifier(entry.getKey(), entry.getValue());
            }
        } else {
            this.qualifiers = null;
        }
        return this;
    }

    public PackageUrlBuilder qualifiers(String qualifiers) {
        return this.qualifiers(PackageUrlParser.parseQualifiers(qualifiers));
    }

    public PackageUrlBuilder qualifier(String key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.getQualifiers().put(key, value);
        return this;
    }

    public PackageUrlBuilder subpath(List<String> subpath) {
        this.subpath = subpath;
        return this;
    }

    public PackageUrlBuilder subpath(String subpath) {
        return this.subpath(PackageUrlParser.parseSubpath(subpath));
    }

    public PackageUrl build() {
        return this.buildAndValidate(true);
    }

    PackageUrl buildAndValidate(boolean validate) {
        String correctedName;
        List<String> correctedNamespace;
        block16: {
            if (validate) {
                PackageUrlValidator.validateType(this.type);
                PackageUrlValidator.validateNamespace(this.namespace);
                PackageUrlValidator.validateName(this.name);
                PackageUrlValidator.validateVersion(this.version);
                PackageUrlValidator.validateQualifiers(this.qualifiers);
                PackageUrlValidator.validateSubpath(this.subpath);
            }
            correctedNamespace = this.namespace;
            correctedName = this.name;
            if (!this.typeSpecificTransformations) break block16;
            switch (this.type) {
                case "github": 
                case "bitbucket": {
                    correctedNamespace = MoreStrings.lowerCase(this.namespace);
                    correctedName = MoreStrings.lowerCase(this.name);
                    break;
                }
                case "pypi": {
                    correctedName = this.name.replace('_', '-');
                    correctedName = MoreStrings.lowerCase(correctedName);
                }
            }
        }
        TreeMap<String, String> correctedQualifiers = null;
        if (this.qualifiers != null) {
            correctedQualifiers = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : this.qualifiers.entrySet()) {
                String key = MoreStrings.lowerCase(entry.getKey());
                String value = entry.getValue();
                if (MoreStrings.isBlank(value)) continue;
                correctedQualifiers.put(key, value);
            }
            if (correctedQualifiers.isEmpty()) {
                correctedQualifiers = null;
            }
        }
        return new PackageUrl(this.type, correctedNamespace, correctedName, this.version, correctedQualifiers, this.subpath);
    }
}

