/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.packageurl;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonatype.goodies.packageurl.MoreStrings;
import org.sonatype.goodies.packageurl.PackageUrlBuilder;
import org.sonatype.goodies.packageurl.PackageUrlParser;
import org.sonatype.goodies.packageurl.PercentEncoding;
import org.sonatype.goodies.packageurl.RenderFlavor;

@Immutable
public class PackageUrl
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SCHEME = "pkg";
    private final String type;
    @Nullable
    private final List<String> namespace;
    private final String name;
    @Nullable
    private final String version;
    @Nullable
    private final SortedMap<String, String> qualifiers;
    @Nullable
    private final List<String> subpath;

    PackageUrl(String type, @Nullable List<String> namespace, String name, @Nullable String version, @Nullable SortedMap<String, String> qualifiers, @Nullable List<String> subpath) {
        this.type = Objects.requireNonNull(type);
        this.namespace = namespace != null ? Collections.unmodifiableList(namespace) : null;
        this.name = Objects.requireNonNull(name);
        this.version = version;
        this.qualifiers = qualifiers != null ? Collections.unmodifiableSortedMap(qualifiers) : null;
        this.subpath = subpath != null ? Collections.unmodifiableList(subpath) : null;
    }

    public String getType() {
        return this.type;
    }

    @Nullable
    public List<String> getNamespace() {
        return this.namespace;
    }

    @Nullable
    public String getNamespaceAsString() {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            return PackageUrl.renderSegments(new StringBuilder(), this.namespace, false).toString();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public SortedMap<String, String> getQualifiers() {
        return this.qualifiers;
    }

    @Nullable
    public List<String> getSubpath() {
        return this.subpath;
    }

    @Nullable
    public String getSubpathAsString() {
        if (this.subpath != null && !this.subpath.isEmpty()) {
            return PackageUrl.renderSegments(new StringBuilder(), this.subpath, false).toString();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageUrl that = (PackageUrl)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.qualifiers, that.qualifiers) && Objects.equals(this.subpath, that.subpath);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.namespace, this.name, this.version, this.qualifiers, this.subpath);
    }

    String explain() {
        return "{type='" + this.type + '\'' + ", namespace=" + this.namespace + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", qualifiers=" + this.qualifiers + ", subpath=" + this.subpath + '}';
    }

    public PackageUrlBuilder asBuilder() {
        return new PackageUrlBuilder().from(this);
    }

    public URI toUri() {
        return URI.create(this.toString());
    }

    public String toString() {
        return this.toString(RenderFlavor.getDefault());
    }

    public String toString(RenderFlavor flavor) {
        Objects.requireNonNull(flavor);
        StringBuilder buff = new StringBuilder();
        if (flavor == RenderFlavor.SCHEME) {
            buff.append(SCHEME).append(':');
        }
        buff.append(MoreStrings.lowerCase(this.type));
        if (flavor == RenderFlavor.SCHEME) {
            buff.append('/');
        } else {
            buff.append(':');
        }
        if (this.namespace != null && !this.namespace.isEmpty()) {
            PackageUrl.renderSegments(buff, this.namespace, true);
            buff.append('/');
        }
        buff.append(PercentEncoding.encodeName(this.name));
        if (this.version != null) {
            buff.append('@').append(PercentEncoding.encodeVersion(this.version));
        }
        if (this.qualifiers != null && !this.qualifiers.isEmpty()) {
            buff.append('?');
            String separator = "";
            for (Map.Entry<String, String> entry : this.qualifiers.entrySet()) {
                buff.append(separator).append(entry.getKey()).append('=').append(PercentEncoding.encodeQualifierValue(entry.getValue()));
                separator = "&";
            }
        }
        if (this.subpath != null && !this.subpath.isEmpty()) {
            buff.append('#');
            PackageUrl.renderSegments(buff, this.subpath, true);
        }
        return buff.toString();
    }

    private static StringBuilder renderSegments(StringBuilder buff, List<String> segments, boolean encode) {
        Iterator<String> iter = segments.iterator();
        while (iter.hasNext()) {
            String segment = iter.next();
            if (encode) {
                segment = PercentEncoding.encodeSegment(segment);
            }
            buff.append(segment);
            if (!iter.hasNext()) continue;
            buff.append('/');
        }
        return buff;
    }

    public static PackageUrl parse(String value) {
        return PackageUrl.parser().parse(value);
    }

    public static PackageUrlParser parser() {
        return new PackageUrlParser();
    }

    public static PackageUrlBuilder builder() {
        return new PackageUrlBuilder();
    }
}

